/*
 * Decompiled with CFR 0.152.
 */
package music;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import music.PaintSurface;
import music.backgroundMusic;
import music.commonUtils;
import music.gameCanvas;
import music.getBackgroundNoise;
import music.getFrequency;
import music.musicScore;
import music.popupCanvas;
import music.settings;
import music.songConverter;
import org.jdesktop.layout.GroupLayout;

public class Main
implements Runnable {
    public static final String name = "Music Hero";
    private static final boolean TRIAL = false;
    public static final boolean debug = false;
    public static boolean debugErrors = true;
    public musicScore score;
    public static String[] userInput = new String[]{"", "0"};
    private final settings settingsLabel;
    private static String selectedFileName;
    private static final double noiseAllowance = 1.3;
    private static int instTranspose;
    private static boolean cont;
    private static boolean isTreble;
    private static int choice;
    public static boolean dopause;
    public static boolean runThread;
    private static boolean cancel;
    public static JFrame f;
    private static final int popupHeight = 40;
    public static final Image imgIcon;
    public static final Icon icoIcon;
    public static popupCanvas popup;
    private static int[] hshc;
    private Point lastWindowLocation;
    private gameCanvas gameboard;
    private static boolean micWorks;
    public static File directory;
    private final songConverter convertLabel;
    public static final String[] instList;
    public static backgroundMusic song;
    public static Color[] colors;

    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].toLowerCase().equals("debug")) {
                debugErrors = true;
                System.out.println("Entering debug mode.  If any errors are made,they will print to this window.  Please email admin@testfrenzy.comto report any issues.");
            } else {
                System.out.println("Command unrecognized.  The only parameter accepted is 'debug'.  If you don't want to enter debugmode, just run 'java -jar music.jar' from the gamedirectory.");
                return;
            }
        }
        new Main();
    }

    public Main() {
        block2: {
            this.settingsLabel = new settings();
            this.lastWindowLocation = null;
            this.convertLabel = new songConverter();
            try {
                directory = new File(".").getCanonicalFile();
            }
            catch (Exception e) {
                if (!debugErrors) break block2;
                System.out.println(e);
            }
        }
        Calendar cal = Calendar.getInstance();
        song = new backgroundMusic();
        this.menu();
    }

    public void menu() {
        block8: {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                if (!debugErrors) break block8;
                System.out.println(e);
            }
        }
        int selection = 0;
        while (selection != 9) {
            selection = this.getChoice();
            switch (selection) {
                case 1: {
                    this.Play();
                    this.setUIFont(new FontUIResource("default", 0, 11));
                    selection = 0;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        this.cleanUpFiles();
        System.exit(0);
    }

    public int getChoice() {
        choice = 0;
        final Font plainFont = new Font("default", 0, 37);
        final Font boldFont = new Font("default", 1, 37);
        final JFrame e = new JFrame(name);
        e.setDefaultCloseOperation(3);
        e.setIconImage(imgIcon);
        e.setResizable(false);
        JLayeredPane layeredPanel = new JLayeredPane();
        PaintSurface backgroundPanel = new PaintSurface("b0.jpg");
        JLabel musicLabel = new JLabel("<html>" + commonUtils.rainbowText(name, colors) + "</html>");
        final JLabel playLabel = new JLabel("<html><font color=black>Play</font></html>");
        final JLabel instructionsLabel = new JLabel("<html><font color=black>Instructions</font></html>");
        final JLabel creditsLabel = new JLabel("<html><font color=black>Credits</font></html>");
        final JLabel quitLabel = new JLabel("<html><font color=black>Quit</font></html>");
        this.settingsLabel.setFrame(e);
        this.settingsLabel.setText("<html><font color=black>Change Settings</font></html>");
        this.convertLabel.setText("<html><font color=black>Convert your Music</font></html>");
        musicLabel.setFont(new Font("default", 1, 67));
        playLabel.setFont(plainFont);
        instructionsLabel.setFont(plainFont);
        creditsLabel.setFont(plainFont);
        this.convertLabel.setFont(plainFont);
        this.settingsLabel.setFont(plainFont);
        quitLabel.setFont(plainFont);
        int ht = Math.max((settings.screenHeight - 90) / 7, 45);
        int inc = (settings.screenHeight - 145) / 6;
        musicLabel.setBounds(40, 15, 600, 60);
        layeredPanel.add((Component)playLabel, JLayeredPane.MODAL_LAYER);
        playLabel.setBounds(40, 30 + inc, 80, ht);
        layeredPanel.add((Component)musicLabel, JLayeredPane.MODAL_LAYER);
        instructionsLabel.setBounds(40, 30 + 2 * inc, 210, ht);
        layeredPanel.add((Component)instructionsLabel, JLayeredPane.MODAL_LAYER);
        this.settingsLabel.setBounds(40, 30 + 3 * inc, 300, ht);
        layeredPanel.add((Component)this.settingsLabel, JLayeredPane.MODAL_LAYER);
        this.convertLabel.setBounds(40, 30 + 4 * inc, 350, ht);
        layeredPanel.add((Component)this.convertLabel, JLayeredPane.MODAL_LAYER);
        creditsLabel.setBounds(40, 30 + 5 * inc, 130, ht);
        layeredPanel.add((Component)creditsLabel, JLayeredPane.MODAL_LAYER);
        quitLabel.setBounds(40, 30 + 6 * inc, 80, ht);
        layeredPanel.add((Component)quitLabel, JLayeredPane.MODAL_LAYER);
        song.setBounds(settings.screenWidth - 120, settings.screenHeight - 120, 80, ht);
        layeredPanel.add((Component)song, JLayeredPane.MODAL_LAYER);
        GroupLayout backgroundPanelLayout = new GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(1).add(0, settings.screenWidth, Short.MAX_VALUE));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(1).add(0, settings.screenWidth, Short.MAX_VALUE));
        backgroundPanel.setBounds(0, 0, settings.screenWidth, settings.screenHeight);
        layeredPanel.add((Component)backgroundPanel, JLayeredPane.PALETTE_LAYER);
        GroupLayout layout = new GroupLayout(e.getContentPane());
        e.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layeredPanel, -1, settings.screenWidth, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layeredPanel, -1, settings.screenHeight, Short.MAX_VALUE));
        e.setSize(settings.screenWidth, settings.screenHeight);
        if (this.lastWindowLocation == null) {
            e.setLocationRelativeTo(null);
            this.lastWindowLocation = e.getLocation();
        } else {
            e.setLocation(this.lastWindowLocation);
        }
        playLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent evt) {
                choice = 1;
            }

            public void mouseEntered(MouseEvent e) {
                playLabel.setFont(boldFont);
            }

            public void mouseExited(MouseEvent e) {
                playLabel.setFont(plainFont);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        instructionsLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent evt) {
                String text = commonUtils.dialogFormat("<html>" + commonUtils.rainbowText(Main.name, colors) + "<font color='000000'> " + "is an educational game aimed to make practicing music more exciting.  " + "To play a game, press 'Play' choose a song to play " + "and the instrument you're playing it with.  Play the notes when they reach " + "the black clef. The note you're currently singing or playing is shown to the " + "left of the clef.  Points are awarded for accuracy.  For scoring to work, you " + "must use a microphone with your computer.  Playing multiple correct notes in  " + "a row gives a combo bonus multiplier to your score.  To pause or unpause " + "the game, click the window, press the spacebar, or press p. To speed or slow " + "the tempo in the game, press the up and down arrows.  To write your own " + "scores to play, use a text editor and follow the format: " + "noteNameandOctave wholeNumberOrFractionLength.  For example, A4 1/4 will " + "show a quarter note A in the 4th octave.  At any time between notes, you " + "may type a tempo in BPM.  The first text in the file must be a tempo. The " + "following represents a complete file of 1 slow note followed by 2 fast: " + "60 D4 1/4 120 E4 1/4 E4 1/4.</html>", 80);
                JOptionPane.showMessageDialog(e, text, "Music Hero - Instructions", 1, icoIcon);
            }

            public void mouseEntered(MouseEvent e2) {
                instructionsLabel.setFont(boldFont);
            }

            public void mouseExited(MouseEvent e2) {
                instructionsLabel.setFont(plainFont);
            }

            public void mousePressed(MouseEvent e2) {
            }

            public void mouseReleased(MouseEvent e2) {
            }
        });
        creditsLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent evt) {
                Main.credits(e);
            }

            public void mouseEntered(MouseEvent e2) {
                creditsLabel.setFont(boldFont);
            }

            public void mouseExited(MouseEvent e2) {
                creditsLabel.setFont(plainFont);
            }

            public void mousePressed(MouseEvent e2) {
            }

            public void mouseReleased(MouseEvent e2) {
            }
        });
        this.settingsLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent evt) {
            }

            public void mouseEntered(MouseEvent e) {
                Main.this.settingsLabel.setFont(boldFont);
            }

            public void mouseExited(MouseEvent e) {
                Main.this.settingsLabel.setFont(plainFont);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent mR) {
                Main.this.settingsLabel.changeSettings();
            }
        });
        this.convertLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent evt) {
            }

            public void mouseEntered(MouseEvent e2) {
                Main.this.convertLabel.setFont(boldFont);
            }

            public void mouseExited(MouseEvent e2) {
                Main.this.convertLabel.setFont(plainFont);
            }

            public void mousePressed(MouseEvent me) {
                Rectangle bounds = Main.this.convertLabel.getBounds();
                Main.this.convertLabel.setBounds(bounds.x, bounds.y, 300, bounds.height);
                Main.this.convertLabel.setText("<html><font color='#000000'>Please Wait...</font>");
                Main.this.convertLabel.paintImmediately(Main.this.convertLabel.getBounds());
                boolean conversionSuccess = Main.this.convertLabel.convertSong(e, settings.screenWidth / 2, settings.screenHeight / 2);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException Ie) {
                    // empty catch block
                }
                if (!conversionSuccess) {
                    bounds.width = 550;
                    Main.this.convertLabel.setBounds(bounds);
                    Main.this.convertLabel.setText("<html><font color='#000000'>Canceled. Convert your Music</font>");
                }
            }

            public void mouseReleased(MouseEvent mR) {
            }
        });
        quitLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent evt) {
                choice = 9;
            }

            public void mouseEntered(MouseEvent e) {
                quitLabel.setFont(boldFont);
            }

            public void mouseExited(MouseEvent e) {
                quitLabel.setFont(plainFont);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        e.setVisible(true);
        while (choice == 0) {
            commonUtils.sleep(10);
        }
        this.convertLabel.reset();
        this.lastWindowLocation = e.getLocation();
        e.setVisible(false);
        e.dispose();
        return choice;
    }

    public void Play() {
        int transpositionAmount;
        block16: {
            chooserThread t = new chooserThread();
            f.setResizable(false);
            this.setUIFont(new FontUIResource("Sans-Serif", 1, 15));
            final JLabel title = new JLabel("<html><font color=black>Choose a song above to begin.</html>");
            final JLabel sliderDesc = new JLabel("<html><font color=black>Tempo: 60 BPM</html>");
            JLabel clefTitle = new JLabel("<html><font color=black>Treble Clef&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bass Clef</html>");
            JLabel transLabel = new JLabel("<html><font color=black>Instrument: </html>");
            JLabel spinnerDesc = new JLabel("<html><font color=black>Transposition in half steps?</html>");
            final JSlider slider = new JSlider();
            final JButton continueButton = new JButton("<html><font color=black>Select a Song</html>");
            JLayeredPane layeredPane = new JLayeredPane();
            PaintSurface background = new PaintSurface("b1.jpg");
            ButtonGroup clefButtons = new ButtonGroup();
            JComboBox<String> transList = new JComboBox<String>(instList);
            transList.setEditable(false);
            transList.setSelectedIndex(settings.defaultInstrument);
            instTranspose = this.instSelectionToInstTranspose(settings.defaultInstrument);
            JRadioButton treble = new JRadioButton("<html><font color=black>Treble Clef</html>");
            JRadioButton bass = new JRadioButton("<html><font color=black>Bass Clef</html>");
            treble.setSelected(isTreble);
            bass.setSelected(!isTreble);
            clefButtons.add(treble);
            clefButtons.add(bass);
            JSpinner spinner = new JSpinner();
            slider.setValue(30);
            slider.setOpaque(false);
            treble.setOpaque(false);
            bass.setOpaque(false);
            final int firstNotePx = settings.screenWidth + settings.PPB / 4;
            continueButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ie) {
                    if (continueButton.getText().equals("<html><font color=black>Continue</html>")) {
                        cont = true;
                    }
                }
            });
            slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    sliderDesc.setText("Tempo: " + Integer.toString(2 * slider.getValue()) + " BPM");
                }
            });
            treble.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ie) {
                    isTreble = true;
                }
            });
            bass.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ie) {
                    isTreble = false;
                }
            });
            transList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ie) {
                    JComboBox cb = (JComboBox)ie.getSource();
                    instTranspose = Main.this.instSelectionToInstTranspose(cb.getSelectedIndex());
                }
            });
            final JFileChooser chooser = t.returnChooser();
            chooser.setOpaque(true);
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".txt") || f.isDirectory();
                }

                public String getDescription() {
                    return "Music Files";
                }
            });
            chooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String command = evt.getActionCommand();
                    if (command.equals("ApproveSelection")) {
                        if (chooser.getSelectedFile().length() == 0L) {
                            JOptionPane.showMessageDialog(f, "The file you've chosen is empty!  Please choose again.", "Whoops!", 1, icoIcon);
                        } else {
                            Main.this.score = new musicScore();
                            selectedFileName = chooser.getSelectedFile().getName();
                            Main.this.score.readFile(chooser.getSelectedFile(), firstNotePx);
                            Main.this.score.concertAndDisplayTranspose(0, instTranspose);
                            Main.this.updateRange(title);
                            sliderDesc.setText("<html><font color=black>Tempo: " + Main.this.score.BPMarray[0] + " BPM</html>");
                            slider.setValue(Main.this.score.BPMarray[0] / 2);
                            continueButton.setText("<html><font color=black>Continue</html>");
                        }
                    } else if (command.equals("CancelSelection")) {
                        f.setVisible(false);
                        f.dispose();
                        cancel = true;
                    }
                }
            });
            GroupLayout backgroundLayout = new GroupLayout(background);
            background.setLayout(backgroundLayout);
            backgroundLayout.setHorizontalGroup(backgroundLayout.createParallelGroup(1).add(0, settings.screenWidth, Short.MAX_VALUE));
            backgroundLayout.setVerticalGroup(backgroundLayout.createParallelGroup(1).add(0, settings.screenHeight, Short.MAX_VALUE));
            background.setBounds(0, 0, settings.screenWidth, settings.screenHeight);
            layeredPane.add((Component)background, JLayeredPane.DEFAULT_LAYER);
            chooser.setBounds(25, 25, settings.screenWidth - 50, settings.screenHeight - 240);
            layeredPane.add((Component)chooser, JLayeredPane.MODAL_LAYER);
            int sliderWidth = settings.screenWidth / 4;
            slider.setBounds(25, settings.screenHeight - 140, sliderWidth, 25);
            layeredPane.add((Component)slider, JLayeredPane.MODAL_LAYER);
            sliderDesc.setBounds(25 + sliderWidth + 15, settings.screenHeight - 140, 150, 20);
            layeredPane.add((Component)sliderDesc, JLayeredPane.MODAL_LAYER);
            spinner.setBounds(settings.screenWidth / 2 + 210, settings.screenHeight - 90, 50, 20);
            layeredPane.add((Component)spinner, JLayeredPane.MODAL_LAYER);
            spinnerDesc.setBounds(settings.screenWidth / 2, settings.screenHeight - 90, 205, 20);
            layeredPane.add((Component)spinnerDesc, JLayeredPane.MODAL_LAYER);
            transList.setBounds(settings.screenWidth / 2 + 100, settings.screenHeight - 140, settings.screenWidth / 2 - 125, 20);
            layeredPane.add((Component)transList, JLayeredPane.MODAL_LAYER);
            transLabel.setBounds(settings.screenWidth / 2, settings.screenHeight - 140, 100, 20);
            layeredPane.add((Component)transLabel, JLayeredPane.MODAL_LAYER);
            treble.setBounds(settings.screenWidth / 4 - 50, settings.screenHeight - 75, 16, 16);
            layeredPane.add((Component)treble, JLayeredPane.MODAL_LAYER);
            bass.setBounds(settings.screenWidth / 4 + 50, settings.screenHeight - 75, 16, 16);
            layeredPane.add((Component)bass, JLayeredPane.MODAL_LAYER);
            int buttonWidth = Math.max(160, settings.screenWidth / 5);
            continueButton.setBounds(settings.screenWidth / 2 - buttonWidth / 2, settings.screenHeight - 43, buttonWidth, 23);
            layeredPane.add((Component)continueButton, JLayeredPane.MODAL_LAYER);
            title.setHorizontalAlignment(0);
            title.setBounds(25, settings.screenHeight - 190, settings.screenWidth - 50, 20);
            layeredPane.add((Component)title, JLayeredPane.MODAL_LAYER);
            int clefTitleW = 172;
            clefTitle.setBounds(5 + settings.screenWidth / 4 - clefTitleW / 2, settings.screenHeight - 95, clefTitleW, 14);
            layeredPane.add((Component)clefTitle, JLayeredPane.MODAL_LAYER);
            GroupLayout layout = new GroupLayout(f.getContentPane());
            f.getContentPane().setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(1).add(layeredPane, -1, settings.screenWidth, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(1).add(layeredPane, -1, settings.screenHeight, Short.MAX_VALUE));
            f.pack();
            if (this.lastWindowLocation != null) {
                f.setLocation(this.lastWindowLocation);
            }
            f.setVisible(true);
            f.setDefaultCloseOperation(3);
            f.setIconImage(imgIcon);
            chooser.repaint();
            while (!cont || selectedFileName == null) {
                commonUtils.sleep(20);
                if (!cancel) continue;
            }
            title.setText("Choose a song above to begin.");
            this.setUIFont(new FontUIResource("Sans-Serif", 1, 12));
            if (cancel) {
                cancel = false;
                return;
            }
            song.off();
            transpositionAmount = 0;
            transpositionAmount = (Integer)spinner.getValue();
            if (!isTreble) {
                transpositionAmount += 21;
            }
            gameCanvas.changeTimeMultiplier((double)(2 * slider.getValue()) / (double)this.score.BPMarray[0]);
            getBackgroundNoise noise = new getBackgroundNoise(f);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                if (!debugErrors) break block16;
                System.out.println(e);
            }
        }
        this.score.concertAndDisplayTranspose(transpositionAmount, instTranspose);
        gameCanvas.useSharps = this.score.findAccidentals();
        runThread = true;
        this.lastWindowLocation = f.getLocation();
        JFrame g = new JFrame("Music Hero - " + selectedFileName.substring(0, selectedFileName.length() - 4));
        g.setIconImage(imgIcon);
        g.setSize(settings.screenWidth, settings.screenHeight);
        g.setLocation(this.lastWindowLocation);
        g.setDefaultCloseOperation(3);
        JLayeredPane jLayeredPane = new JLayeredPane();
        this.gameboard = new gameCanvas(instTranspose, this.score);
        popup = new popupCanvas(isTreble);
        this.gameboard.setBounds(0, 0, settings.screenWidth, settings.screenHeight);
        jLayeredPane.add((Component)this.gameboard, JLayeredPane.PALETTE_LAYER);
        popup.setBounds(15, (settings.screenHeight - 40) / 2, 75, 40);
        jLayeredPane.add((Component)popup, JLayeredPane.MODAL_LAYER);
        GroupLayout gamelayout = new GroupLayout(g.getContentPane());
        g.getContentPane().setLayout(gamelayout);
        gamelayout.setHorizontalGroup(gamelayout.createParallelGroup(1).add(jLayeredPane, -1, settings.screenWidth, Short.MAX_VALUE));
        gamelayout.setVerticalGroup(gamelayout.createParallelGroup(1).add(jLayeredPane, -1, settings.screenHeight, Short.MAX_VALUE));
        f.setVisible(false);
        f.dispose();
        g.setResizable(false);
        g.setVisible(true);
        this.gameboard.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                dopause = !dopause;
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.gameboard.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ' || e.getKeyChar() == 'p') {
                    dopause = !dopause;
                }
            }

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 37: 
                    case 38: {
                        gameCanvas.changeTimeMultiplier(1.1);
                        break;
                    }
                    case 39: 
                    case 40: {
                        gameCanvas.changeTimeMultiplier(0.9);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.playFirstNote(this.score.concertScore[0]);
        if (micWorks) {
            new Thread((Runnable)this, "FrequencyFinder").start();
        }
        block10: while (this.score.haveNotReachedEnd()) {
            while (!dopause) {
                this.gameboard.repaint();
                commonUtils.sleep(1);
                if (this.score.haveNotReachedEnd()) continue;
                continue block10;
            }
        }
        runThread = false;
        popupCanvas.reset();
        jLayeredPane.remove(popup);
        String message = "You Scored " + gameCanvas.gameScore + " Points and your Highest Combo was " + gameCanvas.maxCombo + "!";
        switch (Main.highScore(selectedFileName, gameCanvas.gameScore, gameCanvas.maxCombo)) {
            case -1: {
                message = message + "<br>Error in High Scores File";
                break;
            }
            case 0: {
                message = message + "<br>High Score was " + hshc[0] + " and the Record Combo was " + hshc[1] + ".";
                break;
            }
            case 1: {
                message = "New Record Combo!<br>" + message + "<br>The High Score was " + hshc[0] + ".";
                break;
            }
            case 2: {
                message = "New High Score!<br>" + message + "<br>The Record Combo was " + hshc[1] + ".";
                break;
            }
            case 3: {
                message = "New High Score and New Record Combo!<br>" + message;
            }
        }
        message = "<html>" + message + "</html>";
        this.lastWindowLocation = g.getLocation();
        g.setVisible(false);
        g.dispose();
        g = null;
        JFrame temp = new JFrame("");
        temp.setLocation((int)this.lastWindowLocation.getX() + settings.screenWidth / 2, (int)this.lastWindowLocation.getY() + settings.screenHeight / 2);
        temp.setVisible(true);
        JOptionPane.showMessageDialog(temp, message, "Congratulations!", 1, icoIcon);
        temp.dispose();
        temp = null;
        cont = false;
        popup = null;
        selectedFileName = null;
        gameCanvas.gameScore = 0;
        gameCanvas.maxCombo = 0;
        this.gameboard.reset();
        this.gameboard = null;
        this.score = null;
        song.playRandomSong();
    }

    private void updateRange(JLabel title) {
        String[] range_array = this.score.range();
        title.setText("<html><font color=black>Selected  " + selectedFileName.substring(0, selectedFileName.length() - 4) + ". Concert Pitch Range: " + range_array[0] + " to " + range_array[1] + ".</html>");
    }

    public void run() {
        AudioFormat linearFormat = commonUtils.getAudioFormat();
        byte[] voiceData = new byte[(int)linearFormat.getFrameRate()];
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, linearFormat);
        File audioFile = new File("sample.wav");
        TargetDataLine targetDataLine = null;
        try {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(linearFormat);
        }
        catch (Exception e) {
            if (debugErrors) {
                System.out.println("Could not open targetDataLine.");
                e.printStackTrace();
            }
            micWorks = false;
            JOptionPane.showMessageDialog(null, "<html>Your microphone could not be found.  If you have one,<br> make sure it's working and restart the program.  If you don't<br> have a microphone, this game can't hear you play.  You may <br>still run it to display music.", "Error", 2, icoIcon);
            return;
        }
        AudioInputStream linearStream = new AudioInputStream(targetDataLine);
        int count = 3;
        double[] amplitudes = new double[count];
        while (runThread) {
            block6: {
                getFrequency.record(voiceData, linearFormat, info, audioFile, linearStream, targetDataLine);
                try {
                    userInput = getFrequency.frequency(audioFile);
                }
                catch (IOException ex) {
                    if (!debugErrors) break block6;
                    System.out.println(ex);
                }
            }
            if (settings.backgroundNoise != 0.0) continue;
            double input = Double.parseDouble(userInput[1]);
            if (count < 3 && input == amplitudes[count]) break;
            amplitudes[count - 1] = input;
            if (--count != 0) continue;
            settings.backgroundNoise = 1.3 * commonUtils.avg(amplitudes);
        }
        targetDataLine.stop();
        targetDataLine.close();
        voiceData = null;
        linearFormat = null;
        info = null;
        audioFile = null;
        targetDataLine = null;
        linearStream = null;
    }

    private void playFirstNote(String note) {
        try {
            Synthesizer synthesizer = null;
            synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            MidiChannel channel = synthesizer.getChannels()[12];
            int n = gameCanvas.stringtoMidi(note);
            if (n == 0) {
                return;
            }
            channel.noteOn(n, 50);
            Thread.sleep(settings.firstNoteLength);
            channel.noteOff(n);
        }
        catch (MidiUnavailableException ex) {
            if (debugErrors) {
                System.out.println(ex);
            }
            return;
        }
        catch (InterruptedException ex) {
            if (debugErrors) {
                System.out.println(ex);
            }
            return;
        }
    }

    private void setUIFont(FontUIResource font) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, font);
        }
    }

    private static int highScore(String title, int score, int combo) {
        boolean HC;
        boolean HS;
        block15: {
            String text = "";
            HS = false;
            HC = false;
            boolean foundTitle = false;
            try {
                BufferedReader in = new BufferedReader(new FileReader("scores.music"));
                text = in.readLine();
                in.close();
            }
            catch (IOException e) {
                if (debugErrors) {
                    System.out.println(e);
                }
                return -1;
            }
            if (text == null) {
                text = "%";
            }
            StringTokenizer st = new StringTokenizer(text, "%");
            int tokenCount = st.countTokens();
            text = "";
            for (int i = 0; i < tokenCount; ++i) {
                String strg = st.nextToken();
                text = text.concat(strg.concat("%"));
                if (!strg.equals(title)) continue;
                foundTitle = true;
                strg = st.nextToken();
                ++i;
                Main.hshc[0] = Integer.parseInt(strg);
                if (hshc[0] < score) {
                    text = text.concat(Integer.toString(score).concat("%"));
                    HS = true;
                } else {
                    text = text.concat(strg.concat("%"));
                    HS = false;
                }
                strg = st.nextToken();
                ++i;
                Main.hshc[1] = Integer.parseInt(strg);
                if (hshc[1] < combo) {
                    text = text.concat(Integer.toString(combo).concat("%"));
                    HC = true;
                    continue;
                }
                text = text.concat(strg.concat("%"));
                HC = false;
            }
            if (!foundTitle) {
                text = text + title + "%" + score + "%" + combo + "%";
                HS = true;
                HC = true;
            }
            if (HS || HC) {
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter("scores.music"));
                    out.write(text);
                    out.close();
                }
                catch (IOException e) {
                    if (!debugErrors) break block15;
                    System.out.println(e);
                }
            }
        }
        if (HS) {
            if (HC) {
                return 3;
            }
            return 2;
        }
        if (HC) {
            return 1;
        }
        return 0;
    }

    private static final Image getIconImage() {
        BufferedImage i;
        block2: {
            i = null;
            try {
                i = ImageIO.read(new File("img" + File.separator + "music_icon.gif"));
            }
            catch (IOException ex) {
                if (!debugErrors) break block2;
                System.out.println("Could not read image img" + File.separator + "music_icon.gif" + ex);
            }
        }
        return i;
    }

    private static final Icon getIconIcon() {
        return new ImageIcon(imgIcon);
    }

    private static void credits(JFrame parent) {
        JOptionPane.showMessageDialog(parent, "<html>Game Concept, Programming, and Art: John Grasel<br>Music Source: Musopen<br>Music Composers: Beethoven, Dvorak, Holst, Rimsky-Korsakov, Sousa, Tchaikovsky, Wagner<br>Music Artists: US Air Force Band, US Army Band, US Navy Band, Skidmore College Orchestra<br>Special Thanks to Professor Bob Keller and Ben JonesImage Credits:<br>http://www.hownet.com/blog/wwizardblogimages/music-notes.gif<br>http://wallpapers.dpics.org/21__Sheet_Music.htm#ddl<br>http://djguyky.com/images/music-notes1.png<br><br>None of the images had any cited author. If one of these images is yours and you would<br>like credit or have yoru work removed, please email admin@testfrenzy.com.", "Credits", 1, icoIcon);
    }

    private int instSelectionToInstTranspose(int selectedIndex) {
        switch (selectedIndex) {
            case 0: {
                getFrequency.setBounds(600, 5000);
                return -12;
            }
            case 1: {
                getFrequency.setBounds(150, 1400);
                return -5;
            }
            case 2: {
                getFrequency.setBounds(50, 4000);
                return 0;
            }
            case 3: {
                getFrequency.setBounds(250, 2500);
                return 0;
            }
            case 4: {
                getFrequency.setBounds(170, 1000);
                return 0;
            }
            case 5: {
                getFrequency.setBounds(250, 1500);
                return 0;
            }
            case 6: {
                getFrequency.setBounds(250, 1000);
                return 0;
            }
            case 7: {
                getFrequency.setBounds(200, 700);
                return 0;
            }
            case 8: {
                getFrequency.setBounds(100, 450);
                return 0;
            }
            case 9: {
                getFrequency.setBounds(50, 400);
                return 0;
            }
            case 10: {
                return 1;
            }
            case 11: {
                getFrequency.setBounds(200, 1000);
                return 2;
            }
            case 12: {
                getFrequency.setBounds(125, 2000);
                return 2;
            }
            case 13: {
                return 3;
            }
            case 14: {
                return 4;
            }
            case 15: {
                return 5;
            }
            case 16: {
                return 6;
            }
            case 17: {
                getFrequency.setBounds(63, 750);
                return 7;
            }
            case 18: {
                getFrequency.setBounds(160, 1000);
                return 7;
            }
            case 19: {
                return 8;
            }
            case 20: {
                getFrequency.setBounds(125, 900);
                return 9;
            }
            case 21: {
                return 10;
            }
            case 22: {
                getFrequency.setBounds(80, 630);
                return 12;
            }
            case 23: {
                getFrequency.setBounds(40, 250);
                return 12;
            }
            case 24: {
                getFrequency.setBounds(110, 630);
                return 14;
            }
            case 25: {
                getFrequency.setBounds(50, 600);
                return 14;
            }
            case 26: {
                getFrequency.setBounds(75, 800);
                return 14;
            }
        }
        if (debugErrors) {
            System.out.println("Could Not Read Instrument Selection; Given selectedIndex was a " + selectedIndex);
        }
        return 0;
    }

    private void cleanUpFiles() {
        new File("sample.wav").delete();
        new File("spectrum.txt").delete();
    }

    static {
        instTranspose = 0;
        cont = false;
        isTreble = true;
        choice = 0;
        dopause = false;
        runThread = true;
        cancel = false;
        f = new JFrame("Music Hero - Choose your Song!");
        imgIcon = Main.getIconImage();
        icoIcon = Main.getIconIcon();
        hshc = new int[]{0, 0};
        micWorks = true;
        directory = null;
        instList = new String[]{"Piccolo (C 8va)", "Descant Horn (F 8va)", "Piano (C)", "Flute (C)", "Trumpet (C)", "Oboe (C)", "Vocal Soprano (C)", "Vocal Contralto (C)", "Vocal Baritone (C)", "Vocal Bass (C)", "(B)", "Trumpet (Bb)", "Clarinet (Bb)", "(A)", "(Ab)", "(G)", "(F#)", "French Horn (F)", "English Horn (F)", "(E)", "Alto Sax (Eb)", "(D)", "Guitar (C 8vb)", "Bass (C 8vb)", "Tenor Sax (Bb 8vb)", "Baritone (Bb 8vb)", "Bass Clarinet (Bb 8vb)"};
        colors = commonUtils.divideSpectrum(7);
    }

    private class chooserThread
    implements Runnable {
        private JFileChooser file;

        chooserThread() {
            Thread chooser = new Thread(this);
            chooser.start();
        }

        public JFileChooser returnChooser() {
            while (this.file == null) {
                commonUtils.sleep(4);
            }
            return this.file;
        }

        public void run() {
            this.file = new JFileChooser("scores");
        }
    }
}

